package ru.yandex.autotests.directapi.model.api5.campaigns;

import com.yandex.direct.api.v5.campaigns.ObjectFactory;
import com.yandex.direct.api.v5.campaigns.StrategyAverageCpcPerFilter;

import ru.yandex.direct.currency.Currency;

import static ru.yandex.direct.api.v5.common.ConverterUtils.convertToMicros;

public class StrategyAverageCpcPerFilterMap {

    public static final String FILTER_AVERAGE_CPC = "filterAverageCpc";
    public static final String WEEKLY_SPEND_LIMIT = "weeklySpendLimit";
    public static final String BID_CEILING = "bidCeiling";
    private static final ObjectFactory OBJECT_FACTORY = new ObjectFactory();
    private final StrategyAverageCpcPerFilter item;

    public StrategyAverageCpcPerFilterMap() {
        this(new StrategyAverageCpcPerFilter());
    }

    public StrategyAverageCpcPerFilterMap(StrategyAverageCpcPerFilter strategyAverageCpcPerFilter) {
        item = strategyAverageCpcPerFilter;
    }

    public StrategyAverageCpcPerFilter getBean() {
        return item;
    }

    public StrategyAverageCpcPerFilterMap defaultStrategyAverageCpcPerFilter(Currency currency) {
        var averagePrice = currency.getMinAutobudgetAvgPrice();
        return this
                .withFilterAverageCpc(convertToMicros(averagePrice))
                .withBidCeiling(null)
                .withWeeklySpendLimit(null);
    }

    public StrategyAverageCpcPerFilterMap withFilterAverageCpc(Long averageCpc) {
        item.withFilterAverageCpc(OBJECT_FACTORY.createStrategyAverageCpcPerFilterFilterAverageCpc(averageCpc));
        return this;
    }

    public StrategyAverageCpcPerFilterMap withBidCeiling(Long bidCeiling) {
        item.withBidCeiling(OBJECT_FACTORY.createStrategyAverageCpcPerFilterBidCeiling(bidCeiling));
        return this;
    }

    public StrategyAverageCpcPerFilterMap withWeeklySpendLimit(Long weeklyLimit) {
        item.withWeeklySpendLimit(OBJECT_FACTORY.createStrategyAverageCpcWeeklySpendLimit(weeklyLimit));
        return this;
    }
}
