package ru.yandex.autotests.directapi.model.api5.campaigns;

import java.math.BigDecimal;

import com.yandex.direct.api.v5.campaigns.StrategyAverageCpiAdd;

import ru.yandex.direct.currency.Currency;

import static ru.yandex.direct.api.v5.common.ConverterUtils.convertToMicros;

public class StrategyAverageCpiAddMap {

    public static final String AVERAGE_CPI = "averageCpi";
    public static final String BID_CEILING = "bidCeiling";
    public static final String WEEKLY_SPEND_LIMIT = "weeklySpendLimit";
    private final StrategyAverageCpiAdd item;

    public StrategyAverageCpiAddMap() {
        this(new StrategyAverageCpiAdd());
    }

    public StrategyAverageCpiAddMap(StrategyAverageCpiAdd strategyAverageCpiAdd) {
        item = strategyAverageCpiAdd;
    }

    public StrategyAverageCpiAdd getBean() {
        return item;
    }

    public StrategyAverageCpiAddMap defaultStrategyAverageCpi(Currency currency) {
        BigDecimal averagePrice = currency.getMinAutobudgetAvgPrice();
        return this.withAverageCpi(convertToMicros(averagePrice));
    }

    public StrategyAverageCpiAddMap withBidCeiling(Long bidCeiling) {
        item.withBidCeiling(bidCeiling);
        return this;
    }

    public StrategyAverageCpiAddMap withAverageCpi(Long averageCpi) {
        item.withAverageCpi(averageCpi);
        return this;
    }

    public StrategyAverageCpiAddMap withWeeklySpendLimit(Long weeklySpendLimit) {
        item.withWeeklySpendLimit(weeklySpendLimit);
        return this;
    }
}
