package ru.yandex.autotests.directapi.model.api5.campaigns;

import java.math.BigDecimal;

import com.yandex.direct.api.v5.campaigns.ObjectFactory;
import com.yandex.direct.api.v5.campaigns.StrategyAverageCpi;

import ru.yandex.direct.currency.Currency;

import static ru.yandex.direct.api.v5.common.ConverterUtils.convertToMicros;

public class StrategyAverageCpiMap {

    public static final String AVERAGE_CPI = "averageCpi";
    public static final String BID_CEILING = "bidCeiling";
    public static final String WEEKLY_SPEND_LIMIT = "weeklySpendLimit";
    private static final ObjectFactory OBJECT_FACTORY = new ObjectFactory();
    private final StrategyAverageCpi item;

    public StrategyAverageCpiMap() {
        this(new StrategyAverageCpi());
    }

    public StrategyAverageCpiMap(StrategyAverageCpi strategyAverageCpi) {
        item = strategyAverageCpi;
    }

    public StrategyAverageCpi getBean() {
        return item;
    }

    public StrategyAverageCpiMap defaultStrategyAverageCpi(Currency currency) {
        BigDecimal averagePrice = currency.getMinAutobudgetAvgPrice();
        return this
                .withAverageCpi(convertToMicros(averagePrice))
                .withBidCeiling(null)
                .withWeeklySpendLimit(null);
    }

    public StrategyAverageCpiMap withBidCeiling(Long bidCeiling) {
        item.withBidCeiling(OBJECT_FACTORY.createStrategyAverageCpiBidCeiling(bidCeiling));
        return this;
    }

    public StrategyAverageCpiMap withAverageCpi(Long averageCpi) {
        item.withAverageCpi(averageCpi);
        return this;
    }

    public StrategyAverageCpiMap withWeeklySpendLimit(Long weeklySpendLimit) {
        item.withWeeklySpendLimit(OBJECT_FACTORY.createStrategyAverageCpiWeeklySpendLimit(weeklySpendLimit));
        return this;
    }
}
