package ru.yandex.autotests.directapi.model.api5.campaigns;

import com.yandex.direct.api.v5.campaigns.ObjectFactory;
import com.yandex.direct.api.v5.campaigns.StrategyAverageCrr;

public class StrategyAverageCrrMap {

    public static final String GOAL_ID = "goalId";
    public static final String CRR = "crr";
    public static final String WEEKLY_SPEND_LIMIT = "weeklySpendLimit";

    public static final Integer DEFAULT_CRR = 100;
    public static final Long DEFAULT_WEEKLY_SPEND_LIMIT = 500_000_000L;
    public static final Integer MIN_CRR = 1;
    public static final Integer MAX_CRR = 500;
    private static final ObjectFactory OBJECT_FACTORY = new ObjectFactory();
    private final StrategyAverageCrr item;

    public StrategyAverageCrrMap() {
        this(new StrategyAverageCrr());
    }

    public StrategyAverageCrrMap(StrategyAverageCrr strategyAverageCrr) {
        item = strategyAverageCrr;
    }

    public StrategyAverageCrr getBean() {
        return item;
    }

    public StrategyAverageCrrMap withGoalId(Long goalId) {
        item.withGoalId(goalId);
        return this;
    }

    public StrategyAverageCrrMap withCrr(Integer crr) {
        item.withCrr(crr);
        return this;
    }

    public StrategyAverageCrrMap withWeeklySpendLimit(Long weeklySpendLimit) {
        item.withWeeklySpendLimit(OBJECT_FACTORY.createStrategyAverageCrrWeeklySpendLimit(weeklySpendLimit));
        return this;
    }

    public StrategyAverageCrrMap defaultStrategyAverageCrr() {
        return this
                .withCrr(DEFAULT_CRR)
                .withWeeklySpendLimit(DEFAULT_WEEKLY_SPEND_LIMIT);
    }

}
