package ru.yandex.autotests.directapi.model.api5.campaigns;

import com.yandex.direct.api.v5.campaigns.ObjectFactory;
import com.yandex.direct.api.v5.campaigns.StrategyAverageRoi;

public class StrategyAverageRoiMap {

    public static final String RESERVE_RETURN = "reserveReturn";
    public static final String ROI_COEF = "roiCoef";
    public static final String GOAL_ID = "goalId";
    public static final String BID_CEILING = "bidCeiling";
    public static final String WEEKLY_SPEND_LIMIT = "weeklySpendLimit";
    public static final String PROFITABILITY = "profitability";

    public static final Long MIN_PROFITABILITY = 0L; //0
    public static final Long MAX_PROFITABILITY = 100000000L; //100
    public static final Integer MIN_RESERVE_RETURN = 0;
    public static final Integer MAX_RESERVE_RETURN = 100;
    public static final Long MIN_ROI_COEF = -990000L; //-0.99

    public static final Long DEFAULT_PROFITABILITY = 2000000L;
    public static final Integer DEFAULT_RESERVE_RETURN = 10;
    public static final Long DEFAULT_ROI_COEF = 1000000L;

    public static final Long MEANINGFUL_GOAL_OPTIMIZATION_GOAL_ID = 13L;
    private static final ObjectFactory OBJECT_FACTORY = new ObjectFactory();
    private final StrategyAverageRoi item;

    public StrategyAverageRoiMap() {
        this(new StrategyAverageRoi());
    }

    public StrategyAverageRoiMap(StrategyAverageRoi strategyAverageRoi) {
        item = strategyAverageRoi;
    }

    public StrategyAverageRoi getBean() {
        return item;
    }

    public StrategyAverageRoiMap defaultStrategyAverageRoi() {
        return this
                .withReserveReturn(DEFAULT_RESERVE_RETURN)
                .withRoiCoef(DEFAULT_ROI_COEF)
                .withBidCeiling(null)
                .withWeeklySpendLimit(null)
                .withProfitability(null);
    }

    public StrategyAverageRoiMap withReserveReturn(Integer reserveReturn) {
        item.withReserveReturn(reserveReturn);
        return this;
    }

    public StrategyAverageRoiMap withRoiCoef(Long roiCoef) {
        item.withRoiCoef(roiCoef);
        return this;
    }

    public StrategyAverageRoiMap withGoalId(Long goalId) {
        item.withGoalId(goalId);
        return this;
    }

    public StrategyAverageRoiMap withWeeklySpendLimit(Long weeklySpendLimit) {
        item.withWeeklySpendLimit(OBJECT_FACTORY.createStrategyAverageRoiWeeklySpendLimit(weeklySpendLimit));
        return this;
    }

    public StrategyAverageRoiMap withBidCeiling(Long bidCeiling) {
        item.withBidCeiling(OBJECT_FACTORY.createStrategyAverageRoiBidCeiling(bidCeiling));
        return this;
    }

    public StrategyAverageRoiMap withProfitability(Long profitability) {
        item.withProfitability(OBJECT_FACTORY.createStrategyAverageRoiProfitability(profitability));
        return this;
    }
}
