package ru.yandex.autotests.directapi.model.api5.campaigns;

import java.math.BigDecimal;

import com.yandex.direct.api.v5.campaigns.StrategyMaximumAppInstallsAdd;

import ru.yandex.direct.currency.Currency;

import static ru.yandex.direct.api.v5.common.ConverterUtils.convertToMicros;

public class StrategyMaximumAppInstallsAddMap extends StrategyWeeklyBudgetAddBaseMap<StrategyMaximumAppInstallsAddMap> {
    private final StrategyMaximumAppInstallsAdd item;

    public StrategyMaximumAppInstallsAddMap() {
        this(new StrategyMaximumAppInstallsAdd());
    }

    public StrategyMaximumAppInstallsAddMap(StrategyMaximumAppInstallsAdd strategyMaximumAppInstallsAdd) {
        item = strategyMaximumAppInstallsAdd;
    }

    @Override
    protected StrategyMaximumAppInstallsAdd getBean() {
        return item;
    }

    @Override
    protected StrategyMaximumAppInstallsAddMap self() {
        return this;
    }

    public StrategyMaximumAppInstallsAddMap defaultStrategyMaximumAppInstalls(Currency currency) {
        BigDecimal weeklyBudget = currency.getMinAutobudget();
        return this.withWeeklySpendLimit(convertToMicros(weeklyBudget));
    }
}
