package ru.yandex.autotests.directapi.model.api5.campaigns;

import java.math.BigDecimal;

import com.yandex.direct.api.v5.campaigns.StrategyMaximumAppInstalls;

import ru.yandex.direct.currency.Currency;

import static ru.yandex.direct.api.v5.common.ConverterUtils.convertToMicros;

public class StrategyMaximumAppInstallsMap extends StrategyWeeklyBudgetBaseMap<StrategyMaximumAppInstallsMap> {
    private final StrategyMaximumAppInstalls item;

    public StrategyMaximumAppInstallsMap() {
        this(new StrategyMaximumAppInstalls());
    }

    public StrategyMaximumAppInstallsMap(StrategyMaximumAppInstalls strategyMaximumAppInstalls) {
        item = strategyMaximumAppInstalls;
    }

    @Override
    protected StrategyMaximumAppInstalls getBean() {
        return item;
    }

    @Override
    protected StrategyMaximumAppInstallsMap self() {
        return this;
    }

    public StrategyMaximumAppInstallsMap defaultStrategyMaximumAppInstalls(Currency currency) {
        BigDecimal weeklyBudget = currency.getMinAutobudget();
        return this.withWeeklySpendLimit(convertToMicros(weeklyBudget));
    }
}
