package ru.yandex.autotests.directapi.model.api5.campaigns;

import java.math.BigDecimal;

import com.yandex.direct.api.v5.campaigns.StrategyMaximumClicksAdd;

import ru.yandex.direct.currency.Currency;

import static ru.yandex.direct.api.v5.common.ConverterUtils.convertToMicros;

public class StrategyMaximumClicksAddMap extends StrategyWeeklyBudgetAddBaseMap<StrategyMaximumClicksAddMap> {
    private final StrategyMaximumClicksAdd item;

    public StrategyMaximumClicksAddMap() {
        this(new StrategyMaximumClicksAdd());
    }

    public StrategyMaximumClicksAddMap(StrategyMaximumClicksAdd strategyMaximumAppInstallsAdd) {
        item = strategyMaximumAppInstallsAdd;
    }

    @Override
    protected StrategyMaximumClicksAdd getBean() {
        return item;
    }

    @Override
    protected StrategyMaximumClicksAddMap self() {
        return this;
    }

    public StrategyMaximumClicksAddMap defaultStrategyMaximumClicks(Currency currency) {
        BigDecimal weeklyBudget = currency.getMinAutobudget();
        return this.withWeeklySpendLimit(convertToMicros(weeklyBudget));
    }
}
