package ru.yandex.autotests.directapi.model.api5.campaigns;

import java.math.BigDecimal;

import com.yandex.direct.api.v5.campaigns.StrategyMaximumClicks;

import ru.yandex.direct.currency.Currency;

import static ru.yandex.direct.api.v5.common.ConverterUtils.convertToMicros;

/**
 * Created by pavryabov on 19.10.15.
 */
public class StrategyMaximumClicksMap extends StrategyWeeklyBudgetBaseMap<StrategyMaximumClicksMap> {
    private final StrategyMaximumClicks item;

    public StrategyMaximumClicksMap() {
        this(new StrategyMaximumClicks());
    }

    public StrategyMaximumClicksMap(StrategyMaximumClicks strategyMaximumAppInstalls) {
        item = strategyMaximumAppInstalls;
    }

    @Override
    protected StrategyMaximumClicks getBean() {
        return item;
    }

    @Override
    protected StrategyMaximumClicksMap self() {
        return this;
    }

    public StrategyMaximumClicksMap defaultStrategyMaximumClicks(Currency currency) {
        BigDecimal weeklyBudget = currency.getMinAutobudget();
        return this
                .withWeeklySpendLimit(convertToMicros(weeklyBudget))
                .withBidCeiling(null);
    }
}
