package ru.yandex.autotests.directapi.model.api5.campaigns;

import java.math.BigDecimal;

import com.yandex.direct.api.v5.campaigns.StrategyMaximumConversionRateAdd;

import ru.yandex.direct.currency.Currency;

import static ru.yandex.direct.api.v5.common.ConverterUtils.convertToMicros;

public class StrategyMaximumConversionRateAddMap extends StrategyWeeklyBudgetAddBaseMap<StrategyMaximumConversionRateAddMap> {

    public static final Long MEANINGFUL_GOAL_OPTIMIZATION_GOAL_ID = 13L;

    private final StrategyMaximumConversionRateAdd item;

    public StrategyMaximumConversionRateAddMap() {
        this(new StrategyMaximumConversionRateAdd());
    }

    public StrategyMaximumConversionRateAddMap(StrategyMaximumConversionRateAdd strategyMaximumAppInstallsAdd) {
        item = strategyMaximumAppInstallsAdd;
    }

    @Override
    protected StrategyMaximumConversionRateAdd getBean() {
        return item;
    }

    @Override
    protected StrategyMaximumConversionRateAddMap self() {
        return this;
    }

    public StrategyMaximumConversionRateAddMap defaultMaximumConversionRateParams(Currency currency) {
        BigDecimal weeklyBudget = currency.getMinAutobudget();
        return this.withWeeklySpendLimit(convertToMicros(weeklyBudget));
    }

    public StrategyMaximumConversionRateAddMap withGoalId(Long goalId) {
        item.withGoalId(goalId);
        return this;
    }
}
