package ru.yandex.autotests.directapi.model.api5.campaigns;

import java.math.BigDecimal;

import com.yandex.direct.api.v5.campaigns.StrategyMaximumConversionRate;

import ru.yandex.direct.currency.Currency;

import static ru.yandex.direct.api.v5.common.ConverterUtils.convertToMicros;

public class StrategyMaximumConversionRateMap extends StrategyWeeklyBudgetBaseMap<StrategyMaximumConversionRateMap> {

    private final StrategyMaximumConversionRate item;

    public StrategyMaximumConversionRateMap() {
        this(new StrategyMaximumConversionRate());
    }

    public StrategyMaximumConversionRateMap(StrategyMaximumConversionRate strategyMaximumAppInstalls) {
        item = strategyMaximumAppInstalls;
    }

    @Override
    protected StrategyMaximumConversionRate getBean() {
        return item;
    }

    @Override
    protected StrategyMaximumConversionRateMap self() {
        return this;
    }

    public StrategyMaximumConversionRateMap defaultMaximumConversionRateParams(Currency currency) {
        BigDecimal weeklyBudget = currency.getMinAutobudget();
        return this
                .withWeeklySpendLimit(convertToMicros(weeklyBudget))
                .withBidCeiling(null);
    }

    public StrategyMaximumConversionRateMap withGoalId(Long goalId) {
        item.withGoalId(goalId);
        return this;
    }
}
