package ru.yandex.autotests.directapi.model.api5.campaigns;

import com.yandex.direct.api.v5.campaigns.StrategyNetworkDefaultAdd;

public class StrategyNetworkDefaultAddMap {
    public static final Integer TEST_LIMIT_PERCENT = 30;

    public static final Integer DEFAULT_LIMIT_PERCENT = 100;
    private final StrategyNetworkDefaultAdd item;

    public StrategyNetworkDefaultAddMap() {
        this(new StrategyNetworkDefaultAdd());
    }

    public StrategyNetworkDefaultAddMap(StrategyNetworkDefaultAdd networkDefaultParams) {
        item = networkDefaultParams;
    }

    public StrategyNetworkDefaultAdd getBean() {
        return item;
    }

    public StrategyNetworkDefaultAddMap defaultStrategyNetworkDefault() {
        return this.withLimitPercent(TEST_LIMIT_PERCENT);
    }

    public StrategyNetworkDefaultAddMap withLimitPercent(Integer limitPercent) {
        item.withLimitPercent(limitPercent);
        return this;
    }
}
