package ru.yandex.autotests.directapi.model.api5.campaigns;

import com.yandex.direct.api.v5.campaigns.StrategyNetworkDefault;

public class StrategyNetworkDefaultMap {
    public static final Integer TEST_LIMIT_PERCENT = 30;

    public static final Integer DEFAULT_LIMIT_PERCENT = 100;
    private final StrategyNetworkDefault item;

    public StrategyNetworkDefaultMap() {
        this(new StrategyNetworkDefault());
    }

    public StrategyNetworkDefaultMap(StrategyNetworkDefault networkDefaultParams) {
        item = networkDefaultParams;
    }

    public StrategyNetworkDefault getBean() {
        return item;
    }

    public StrategyNetworkDefaultMap defaultStrategyNetworkDefault() {
        return this.withLimitPercent(TEST_LIMIT_PERCENT);
    }

    public StrategyNetworkDefaultMap withLimitPercent(Integer limitPercent) {
        item.withLimitPercent(limitPercent);
        return this;
    }
}
