package ru.yandex.autotests.directapi.model.api5.campaigns;

import com.yandex.direct.api.v5.campaigns.StrategyPayForConversionAdd;

import ru.yandex.direct.currency.Currency;

import static ru.yandex.direct.api.v5.common.ConverterUtils.convertToMicros;

public class StrategyPayForConversionAddMap {

    public static final String CPA = "cpa";
    public static final String WEEKLY_SPEND_LIMIT = "weeklySpendLimit";
    public static final String GOAL_ID = "goalId";
    private final StrategyPayForConversionAdd item;

    public StrategyPayForConversionAddMap() {
        this(new StrategyPayForConversionAdd());
    }

    public StrategyPayForConversionAddMap(StrategyPayForConversionAdd strategyPayForConversionAdd) {
        item = strategyPayForConversionAdd;
    }

    public StrategyPayForConversionAdd getBean() {
        return item;
    }

    public StrategyPayForConversionAddMap defaultStrategyPayForConversion(Currency currency) {
        var averagePrice = currency.getMinAutobudgetAvgPrice();
        return this.withCpa(convertToMicros(averagePrice));
    }

    public StrategyPayForConversionAddMap withCpa(Long cpa) {
        item.withCpa(cpa);
        return this;
    }

    public StrategyPayForConversionAddMap withWeeklySpendLimit(Long weeklySpendLimit) {
        item.withWeeklySpendLimit(weeklySpendLimit);
        return this;
    }

    public StrategyPayForConversionAddMap withGoalId(Long goalId) {
        item.withGoalId(goalId);
        return this;
    }
}
