package ru.yandex.autotests.directapi.model.api5.campaigns;

import com.yandex.direct.api.v5.campaigns.StrategyPayForConversionCrrAdd;

public class StrategyPayForConversionCrrAddMap {

    public static final String CRR = "crr";
    public static final String GOAL_ID = "goalId";
    public static final String WEEKLY_SPEND_LIMIT = "weeklySpendLimit";

    public static final Integer DEFAULT_CRR = 100;
    public static final Integer MIN_CRR = 1;
    public static final Integer MAX_CRR = 500;
    public static final Long DEFAULT_WEEKLY_SPEND_LIMIT = 500_000_000L;
    public static final Long MEANINGFUL_GOAL_OPTIMIZATION_GOAL_ID = 13L;
    private final StrategyPayForConversionCrrAdd item;

    public StrategyPayForConversionCrrAddMap() {
        item = new StrategyPayForConversionCrrAdd();
    }

    public StrategyPayForConversionCrrAdd getBean() {
        return item;
    }

    public StrategyPayForConversionCrrAddMap withCrr(Integer crr) {
        item.withCrr(crr);
        return this;
    }

    public StrategyPayForConversionCrrAddMap withGoalId(Long goalId) {
        item.withGoalId(goalId);
        return this;
    }

    public StrategyPayForConversionCrrAddMap withWeeklySpendLimit(Long weeklySpendLimit) {
        item.withWeeklySpendLimit(weeklySpendLimit);
        return this;
    }

}
