package ru.yandex.autotests.directapi.model.api5.campaigns;

import com.yandex.direct.api.v5.campaigns.ObjectFactory;
import com.yandex.direct.api.v5.campaigns.StrategyPayForConversionCrr;

public class StrategyPayForConversionCrrMap {

    public static final String CRR = "crr";
    public static final String GOAL_ID = "goalId";
    public static final String WEEKLY_SPEND_LIMIT = "weeklySpendLimit";

    public static final Integer DEFAULT_CRR = 100;
    public static final Integer MIN_CRR = 1;
    public static final Integer MAX_CRR = 500;
    public static final Long DEFAULT_WEEKLY_SPEND_LIMIT = 500_000_000L;
    public static final Long MEANINGFUL_GOAL_OPTIMIZATION_GOAL_ID = 13L;
    private static final ObjectFactory OBJECT_FACTORY = new ObjectFactory();
    private final StrategyPayForConversionCrr item;

    public StrategyPayForConversionCrrMap() {
        item = new StrategyPayForConversionCrr();
    }

    public StrategyPayForConversionCrr getBean() {
        return item;
    }

    public StrategyPayForConversionCrrMap withCrr(Integer crr) {
        item.withCrr(crr);
        return this;
    }

    public StrategyPayForConversionCrrMap withGoalId(Long goalId) {
        item.withGoalId(goalId);
        return this;
    }

    public StrategyPayForConversionCrrMap withWeeklySpendLimit(Long weeklySpendLimit) {
        item.withWeeklySpendLimit(OBJECT_FACTORY.createStrategyPayForConversionCrrWeeklySpendLimit(weeklySpendLimit));
        return this;
    }

}
