package ru.yandex.autotests.directapi.model.api5.campaigns;

import com.yandex.direct.api.v5.campaigns.ObjectFactory;
import com.yandex.direct.api.v5.campaigns.StrategyPayForConversion;

import ru.yandex.direct.currency.Currency;

import static ru.yandex.direct.api.v5.common.ConverterUtils.convertToMicros;

public class StrategyPayForConversionMap {

    public static final String CPA = "cpa";
    public static final String WEEKLY_SPEND_LIMIT = "weeklySpendLimit";
    public static final String GOAL_ID = "goalId";
    private static final ObjectFactory OBJECT_FACTORY = new ObjectFactory();
    private final StrategyPayForConversion item;

    public StrategyPayForConversionMap() {
        this(new StrategyPayForConversion());
    }

    public StrategyPayForConversionMap(StrategyPayForConversion strategyPayForConversion) {
        item = strategyPayForConversion;
    }

    public StrategyPayForConversion getBean() {
        return item;
    }

    public StrategyPayForConversionMap defaultStrategyPayForConversion(Currency currency) {
        var averagePrice = currency.getMinAutobudgetAvgPrice();
        return this
                .withCpa(convertToMicros(averagePrice))
                .withWeeklySpendLimit(null);
    }

    public StrategyPayForConversionMap withCpa(Long cpa) {
        item.withCpa(cpa);
        return this;
    }

    public StrategyPayForConversionMap withWeeklySpendLimit(Long weeklySpendLimit) {
        item.withWeeklySpendLimit(OBJECT_FACTORY.createStrategyPayForConversionWeeklySpendLimit(weeklySpendLimit));
        return this;
    }

    public StrategyPayForConversionMap withGoalId(Long goalId) {
        item.withGoalId(goalId);
        return this;
    }
}
