package ru.yandex.autotests.directapi.model.api5.campaigns;

import com.yandex.direct.api.v5.campaigns.StrategyPayForConversionPerCampaignAdd;

import ru.yandex.direct.currency.Currency;

import static ru.yandex.direct.api.v5.common.ConverterUtils.convertToMicros;

public class StrategyPayForConversionPerCampaignAddMap {
    private final StrategyPayForConversionPerCampaignAdd item;

    public StrategyPayForConversionPerCampaignAddMap() {
        this(new StrategyPayForConversionPerCampaignAdd());
    }

    public StrategyPayForConversionPerCampaignAddMap(StrategyPayForConversionPerCampaignAdd strategyPayForConversionAdd) {
        item = strategyPayForConversionAdd;
    }

    public StrategyPayForConversionPerCampaignAdd getBean() {
        return item;
    }

    public StrategyPayForConversionPerCampaignAddMap defaultStrategyPayForConversion(Currency currency) {
        var minCpa = currency.getMinAutobudgetAvgPrice();
        return this.withCpa(convertToMicros(minCpa));
    }

    public StrategyPayForConversionPerCampaignAddMap withCpa(Long cpa) {
        item.withCpa(cpa);
        return this;
    }

    public StrategyPayForConversionPerCampaignAddMap withWeeklySpendLimit(Long weeklySpendLimit) {
        item.withWeeklySpendLimit(weeklySpendLimit);
        return this;
    }

    public StrategyPayForConversionPerCampaignAddMap withGoalId(Long goalId) {
        item.withGoalId(goalId);
        return this;
    }
}
