package ru.yandex.autotests.directapi.model.api5.campaigns;

import com.yandex.direct.api.v5.campaigns.ObjectFactory;
import com.yandex.direct.api.v5.campaigns.StrategyPayForConversionPerCampaign;

import ru.yandex.direct.currency.Currency;

import static ru.yandex.direct.api.v5.common.ConverterUtils.convertToMicros;

public class StrategyPayForConversionPerCampaignMap {
    private static final ObjectFactory OBJECT_FACTORY = new ObjectFactory();
    private final StrategyPayForConversionPerCampaign item;

    public StrategyPayForConversionPerCampaignMap() {
        this(new StrategyPayForConversionPerCampaign());
    }

    public StrategyPayForConversionPerCampaignMap(StrategyPayForConversionPerCampaign strategyPayForConversion) {
        item = strategyPayForConversion;
    }

    public StrategyPayForConversionPerCampaign getBean() {
        return item;
    }

    public StrategyPayForConversionPerCampaignMap defaultStrategyPayForConversion(Currency currency) {
        var minCpa = currency.getMinAutobudgetAvgPrice();
        return this
                .withCpa(convertToMicros(minCpa))
                .withWeeklySpendLimit(null);
    }

    public StrategyPayForConversionPerCampaignMap withCpa(Long cpa) {
        item.withCpa(cpa);
        return this;
    }

    public StrategyPayForConversionPerCampaignMap withWeeklySpendLimit(Long weeklySpendLimit) {
        item.withWeeklySpendLimit(OBJECT_FACTORY.createStrategyPayForConversionPerCampaignWeeklySpendLimit(weeklySpendLimit));
        return this;
    }

    public StrategyPayForConversionPerCampaignMap withGoalId(Long goalId) {
        item.withGoalId(goalId);
        return this;
    }
}
