package ru.yandex.autotests.directapi.model.api5.campaigns;

import com.yandex.direct.api.v5.campaigns.StrategyPayForConversionPerFilterAdd;

import ru.yandex.direct.currency.Currency;

import static ru.yandex.direct.api.v5.common.ConverterUtils.convertToMicros;

public class StrategyPayForConversionPerFilterAddMap {
    private final StrategyPayForConversionPerFilterAdd item;

    public StrategyPayForConversionPerFilterAddMap() {
        this(new StrategyPayForConversionPerFilterAdd());
    }

    public StrategyPayForConversionPerFilterAddMap(StrategyPayForConversionPerFilterAdd strategyPayForConversionAdd) {
        item = strategyPayForConversionAdd;
    }

    public StrategyPayForConversionPerFilterAdd getBean() {
        return item;
    }

    public StrategyPayForConversionPerFilterAddMap defaultStrategyPayForConversion(Currency currency) {
        var minCpa = currency.getMinAutobudgetAvgPrice();
        return this.withCpa(convertToMicros(minCpa));
    }

    public StrategyPayForConversionPerFilterAddMap withCpa(Long cpa) {
        item.withCpa(cpa);
        return this;
    }

    public StrategyPayForConversionPerFilterAddMap withWeeklySpendLimit(Long weeklySpendLimit) {
        item.withWeeklySpendLimit(weeklySpendLimit);
        return this;
    }

    public StrategyPayForConversionPerFilterAddMap withGoalId(Long goalId) {
        item.withGoalId(goalId);
        return this;
    }
}
