package ru.yandex.autotests.directapi.model.api5.campaigns;

import com.yandex.direct.api.v5.campaigns.ObjectFactory;
import com.yandex.direct.api.v5.campaigns.StrategyPayForConversionPerFilter;

import ru.yandex.direct.currency.Currency;

import static ru.yandex.direct.api.v5.common.ConverterUtils.convertToMicros;

public class StrategyPayForConversionPerFilterMap {
    private static final ObjectFactory OBJECT_FACTORY = new ObjectFactory();
    private final StrategyPayForConversionPerFilter item;

    public StrategyPayForConversionPerFilterMap() {
        this(new StrategyPayForConversionPerFilter());
    }

    public StrategyPayForConversionPerFilterMap(StrategyPayForConversionPerFilter strategyPayForConversion) {
        item = strategyPayForConversion;
    }

    public StrategyPayForConversionPerFilter getBean() {
        return item;
    }

    public StrategyPayForConversionPerFilterMap defaultStrategyPayForConversion(Currency currency) {
        var minCpa = currency.getMinAutobudgetAvgPrice();
        return this
                .withCpa(convertToMicros(minCpa))
                .withWeeklySpendLimit(null);
    }

    public StrategyPayForConversionPerFilterMap withCpa(Long cpa) {
        item.withCpa(cpa);
        return this;
    }

    public StrategyPayForConversionPerFilterMap withWeeklySpendLimit(Long weeklySpendLimit) {
        item.withWeeklySpendLimit(OBJECT_FACTORY.createStrategyPayForConversionWeeklySpendLimit(weeklySpendLimit));
        return this;
    }

    public StrategyPayForConversionPerFilterMap withGoalId(Long goalId) {
        item.withGoalId(goalId);
        return this;
    }
}
