package ru.yandex.autotests.directapi.model.api5.campaigns;

import java.math.BigDecimal;

import com.yandex.direct.api.v5.campaigns.StrategyPayForInstallAdd;

import ru.yandex.direct.currency.Currency;

import static ru.yandex.direct.api.v5.common.ConverterUtils.convertToMicros;

public class StrategyPayForInstallAddMap {
    private final StrategyPayForInstallAdd item;

    public StrategyPayForInstallAddMap() {
        this(new StrategyPayForInstallAdd());
    }

    public StrategyPayForInstallAddMap(StrategyPayForInstallAdd strategyPayForInstallAdd) {
        item = strategyPayForInstallAdd;
    }

    public StrategyPayForInstallAdd getBean() {
        return item;
    }

    public StrategyPayForInstallAddMap defaultStrategyPayForConversion(Currency currency) {
        BigDecimal averageCpi = currency.getMinAutobudgetAvgPrice();
        return this.withAverageCpi(convertToMicros(averageCpi));
    }

    public StrategyPayForInstallAddMap withAverageCpi(Long averageCpi) {
        item.withAverageCpi(averageCpi);
        return this;
    }

    public StrategyPayForInstallAddMap withWeeklySpendLimit(Long weeklySpendLimit) {
        item.withWeeklySpendLimit(weeklySpendLimit);
        return this;
    }
}
