package ru.yandex.autotests.directapi.model.api5.campaigns;

import java.math.BigDecimal;

import com.yandex.direct.api.v5.campaigns.ObjectFactory;
import com.yandex.direct.api.v5.campaigns.StrategyPayForInstall;

import ru.yandex.direct.currency.Currency;

import static ru.yandex.direct.api.v5.common.ConverterUtils.convertToMicros;

public class StrategyPayForInstallMap {
    private static final ObjectFactory OBJECT_FACTORY = new ObjectFactory();
    private final StrategyPayForInstall item;

    public StrategyPayForInstallMap() {
        this(new StrategyPayForInstall());
    }

    public StrategyPayForInstallMap(StrategyPayForInstall strategyPayForInstall) {
        item = strategyPayForInstall;
    }

    public StrategyPayForInstall getBean() {
        return item;
    }

    public StrategyPayForInstallMap defaultStrategyPayForConversion(Currency currency) {
        BigDecimal averageCpi = currency.getMinAutobudgetAvgPrice();
        return this
                .withAverageCpi(convertToMicros(averageCpi))
                .withWeeklySpendLimit(null);
    }

    public StrategyPayForInstallMap withAverageCpi(Long averageCpi) {
        item.withAverageCpi(averageCpi);
        return this;
    }

    public StrategyPayForInstallMap withWeeklySpendLimit(Long weeklySpendLimit) {
        item.withWeeklySpendLimit(OBJECT_FACTORY.createStrategyPayForInstallWeeklySpendLimit(weeklySpendLimit));
        return this;
    }
}
