package ru.yandex.autotests.directapi.model.api5.campaigns;

import com.yandex.direct.api.v5.campaigns.StrategyWbAverageCpvAdd;

import ru.yandex.direct.currency.Currency;

import static ru.yandex.direct.api.v5.common.ConverterUtils.convertToMicros;

public class StrategyWbAverageCpvAddMap extends StrategyAverageCpvAddBaseMap<StrategyWbAverageCpvAddMap> {
    private final StrategyWbAverageCpvAdd item;

    public StrategyWbAverageCpvAddMap() {
        this(new StrategyWbAverageCpvAdd());
    }

    public StrategyWbAverageCpvAddMap(StrategyWbAverageCpvAdd strategyWbAverageCpvAddMap) {
        item = strategyWbAverageCpvAddMap;
    }

    @Override
    protected StrategyWbAverageCpvAddMap self() {
        return this;
    }

    @Override
    public StrategyWbAverageCpvAdd getBean() {
        return item;
    }

    public StrategyWbAverageCpvAddMap defaultStrategyWbAverageCpv(Currency currency) {
        var averageCpm = currency.getMinCpmPrice();
        var weeklyBudget = currency.getMaxAutobudget();
        return this
                .withAverageCpv(convertToMicros(averageCpm))
                .withSpendLimit(convertToMicros(weeklyBudget));
    }
}
