package ru.yandex.autotests.directapi.model.api5.campaigns;

import com.yandex.direct.api.v5.campaigns.StrategyWbAverageCpv;

import ru.yandex.direct.currency.Currency;

import static ru.yandex.direct.api.v5.common.ConverterUtils.convertToMicros;

public class StrategyWbAverageCpvMap extends StrategyAverageCpvBaseMap<StrategyWbAverageCpvMap> {
    private final StrategyWbAverageCpv item;

    public StrategyWbAverageCpvMap() {
        this(new StrategyWbAverageCpv());
    }

    public StrategyWbAverageCpvMap(StrategyWbAverageCpv strategyWbAverageCpvMap) {
        item = strategyWbAverageCpvMap;
    }

    @Override
    protected StrategyWbAverageCpvMap self() {
        return this;
    }

    @Override
    public StrategyWbAverageCpv getBean() {
        return item;
    }

    public StrategyWbAverageCpvMap defaultStrategyWbAverageCpv(Currency currency) {
        var averageCpm = currency.getMinCpmPrice();
        var weeklyBudget = currency.getMaxAutobudget();
        return this
                .withAverageCpv(convertToMicros(averageCpm))
                .withSpendLimit(convertToMicros(weeklyBudget));
    }
}
