package ru.yandex.autotests.directapi.model.api5.campaigns;

import com.yandex.direct.api.v5.campaigns.StrategyWbMaximumImpressionsAdd;

import ru.yandex.direct.currency.Currency;

import static ru.yandex.direct.api.v5.common.ConverterUtils.convertToMicros;

public class StrategyWbMaximumImpressionsAddMap extends StrategyMaximizeImpressionsAddBaseMap<StrategyWbMaximumImpressionsAddMap> {
    private final StrategyWbMaximumImpressionsAdd item;

    public StrategyWbMaximumImpressionsAddMap() {
        this(new StrategyWbMaximumImpressionsAdd());
    }

    public StrategyWbMaximumImpressionsAddMap(StrategyWbMaximumImpressionsAdd strategyWbMaximumImpressionsAddMap) {
        item = strategyWbMaximumImpressionsAddMap;
    }

    @Override
    protected StrategyWbMaximumImpressionsAddMap self() {
        return this;
    }

    @Override
    public StrategyWbMaximumImpressionsAdd getBean() {
        return item;
    }

    public StrategyWbMaximumImpressionsAddMap defaultStrategyWbMaximumImpressions(Currency currency) {
        var averageCpm = currency.getMinCpmPrice();
        var weeklyBudget = currency.getMaxAutobudget();
        return this
                .withAverageCpm(convertToMicros(averageCpm))
                .withSpendLimit(convertToMicros(weeklyBudget));
    }
}
