package ru.yandex.autotests.directapi.model.api5.campaigns;

import com.yandex.direct.api.v5.campaigns.StrategyWbMaximumImpressions;

import ru.yandex.direct.currency.Currency;

import static ru.yandex.direct.api.v5.common.ConverterUtils.convertToMicros;

public class StrategyWbMaximumImpressionsMap extends StrategyMaximizeImpressionsBaseMap<StrategyWbMaximumImpressionsMap> {
    private final StrategyWbMaximumImpressions item;

    public StrategyWbMaximumImpressionsMap() {
        this(new StrategyWbMaximumImpressions());
    }

    public StrategyWbMaximumImpressionsMap(StrategyWbMaximumImpressions strategyWbMaximumImpressionsMap) {
        item = strategyWbMaximumImpressionsMap;
    }

    @Override
    protected StrategyWbMaximumImpressionsMap self() {
        return this;
    }

    @Override
    public StrategyWbMaximumImpressions getBean() {
        return item;
    }

    public StrategyWbMaximumImpressionsMap defaultStrategyWbMaximumImpressions(Currency currency) {
        var averageCpm = currency.getMinCpmPrice();
        var weeklyBudget = currency.getMaxAutobudget();
        return this
                .withAverageCpm(convertToMicros(averageCpm))
                .withSpendLimit(convertToMicros(weeklyBudget));
    }
}
