package ru.yandex.autotests.directapi.model.api5.campaigns;

import com.yandex.direct.api.v5.campaigns.StrategyWeeklyBudgetAddBase;

public abstract class StrategyWeeklyBudgetAddBaseMap<T extends StrategyWeeklyBudgetAddBaseMap<T>> {

    public static final String BID_CEILING = "bidCeiling";
    public static final String WEEKLY_SPEND_LIMIT = "weeklySpendLimit";

    protected abstract StrategyWeeklyBudgetAddBase getBean();

    protected abstract T self();

    public T withBidCeiling(Long bidCeiling) {
        getBean().withBidCeiling(bidCeiling);
        return self();
    }

    public T withWeeklySpendLimit(Long weeklySpendLimit) {
        getBean().withWeeklySpendLimit(weeklySpendLimit);
        return self();
    }
}
