package ru.yandex.autotests.directapi.model.api5.campaigns;

import com.yandex.direct.api.v5.campaigns.ObjectFactory;
import com.yandex.direct.api.v5.campaigns.StrategyWeeklyBudgetBase;

/**
 * Created by pavryabov on 19.10.15.
 */
public abstract class StrategyWeeklyBudgetBaseMap<T extends StrategyWeeklyBudgetBaseMap<T>> {

    public static final String BID_CEILING = "bidCeiling";
    public static final String WEEKLY_SPEND_LIMIT = "weeklySpendLimit";
    private static final ObjectFactory OBJECT_FACTORY = new ObjectFactory();

    protected abstract StrategyWeeklyBudgetBase getBean();

    protected abstract T self();

    public T withBidCeiling(Long bidCeiling) {
        getBean().withBidCeiling(OBJECT_FACTORY.createStrategyWeeklyBudgetBaseBidCeiling(bidCeiling));
        return self();
    }

    public T withWeeklySpendLimit(Long weeklySpendLimit) {
        getBean().withWeeklySpendLimit(weeklySpendLimit);
        return self();
    }
}
