package ru.yandex.autotests.directapi.model.api5.campaigns;

import com.yandex.direct.api.v5.campaigns.StrategyWeeklyClickPackageAdd;

public class StrategyWeeklyClickPackageAddMap {

    public static final String BID_CEILING = "bidCeiling";
    public static final String AVERAGE_CPC = "averageCpc";
    public static final String CLICKS_PER_WEEK = "clicksPerWeek";

    public static final Long DEFAULT_CLICKS_PER_WEEK = 1000L;
    public static final Long MIN_CLICKS_PER_WEEK = 100L;
    private final StrategyWeeklyClickPackageAdd item;

    public StrategyWeeklyClickPackageAddMap() {
        this(new StrategyWeeklyClickPackageAdd());
    }

    public StrategyWeeklyClickPackageAddMap(StrategyWeeklyClickPackageAdd strategyWeeklyClickPackage) {
        item = strategyWeeklyClickPackage;
    }

    public StrategyWeeklyClickPackageAdd getBean() {
        return item;
    }

    public StrategyWeeklyClickPackageAddMap defaultStrategyWeeklyClickPackage() {
        return this.withClicksPerWeek(DEFAULT_CLICKS_PER_WEEK);
    }

    public StrategyWeeklyClickPackageAddMap withBidCeiling(Long bidCeling) {
        item.withBidCeiling(bidCeling);
        return this;
    }

    public StrategyWeeklyClickPackageAddMap withClicksPerWeek(Long clicksPerWeek) {
        item.withClicksPerWeek(clicksPerWeek);
        return this;
    }

    public StrategyWeeklyClickPackageAddMap withAverageCpc(Long averagePrice) {
        item.withAverageCpc(averagePrice);
        return this;
    }
}
