package ru.yandex.autotests.directapi.model.api5.campaigns;

import com.yandex.direct.api.v5.campaigns.ObjectFactory;
import com.yandex.direct.api.v5.campaigns.StrategyWeeklyClickPackage;

public class StrategyWeeklyClickPackageMap {

    public static final String BID_CEILING = "bidCeiling";
    public static final String AVERAGE_CPC = "averageCpc";
    public static final String CLICKS_PER_WEEK = "clicksPerWeek";

    public static final Long DEFAULT_CLICKS_PER_WEEK = 1000L;
    public static final Long MIN_CLICKS_PER_WEEK = 100L;
    private static final ObjectFactory OBJECT_FACTORY = new ObjectFactory();
    private final StrategyWeeklyClickPackage item;

    public StrategyWeeklyClickPackageMap() {
        this(new StrategyWeeklyClickPackage());
    }

    public StrategyWeeklyClickPackageMap(StrategyWeeklyClickPackage strategyWeeklyClickPackage) {
        item = strategyWeeklyClickPackage;
    }

    public StrategyWeeklyClickPackage getBean() {
        return item;
    }

    public StrategyWeeklyClickPackageMap defaultStrategyWeeklyClickPackage() {
        return this
                .withClicksPerWeek(DEFAULT_CLICKS_PER_WEEK)
                .withBidCeiling(null);
    }

    public StrategyWeeklyClickPackageMap withBidCeiling(Long bidCeling) {
        item.withBidCeiling(OBJECT_FACTORY.createStrategyWeeklyClickPackageBidCeiling(bidCeling));
        return this;
    }

    public StrategyWeeklyClickPackageMap withClicksPerWeek(Long clicksPerWeek) {
        item.withClicksPerWeek(clicksPerWeek);
        return this;
    }

    public StrategyWeeklyClickPackageMap withAverageCpc(Long averagePrice) {
        item.withAverageCpc(OBJECT_FACTORY.createStrategyWeeklyClickPackageAverageCpc(averagePrice));
        return this;
    }
}
