package ru.yandex.autotests.directapi.model.api5.campaigns;

import com.yandex.direct.api.v5.campaigns.RelevantKeywordsSettingAdd;
import com.yandex.direct.api.v5.campaigns.TextCampaignAddItem;
import com.yandex.direct.api.v5.campaigns.TextCampaignNetworkStrategyTypeEnum;
import com.yandex.direct.api.v5.campaigns.TextCampaignSearchStrategyTypeEnum;
import com.yandex.direct.api.v5.campaigns.TextCampaignSetting;
import com.yandex.direct.api.v5.general.ArrayOfInteger;
import com.yandex.direct.api.v5.general.AttributionModelEnum;

import static ru.yandex.direct.utils.CommonUtils.ifNotNull;

public class TextCampaignAddItemMap {

    public static final String BIDDING_STRATEGY = "biddingStrategy";
    public static final String SETTINGS = "settings";
    public static final String COUNTER_IDS = "counterIds";
    public static final String RELEVANT_KEYWORDS = "relevantKeywords";
    public static final String PRIORITY_GOALS = "priorityGoals";
    public static final String ATTRIBUTION_MODEL = "attributionModel";

    public static final int MAX_AMOUNT_OF_COUNTER_IDS = 100;
    private final TextCampaignAddItem item;

    public TextCampaignAddItemMap() {
        this(new TextCampaignAddItem());
    }

    public TextCampaignAddItemMap(TextCampaignAddItem textCampaignAddItem) {
        item = textCampaignAddItem;
    }

    public TextCampaignAddItem getBean() {
        return item;
    }

    public TextCampaignAddItemMap withBiddingStrategy(TextCampaignStrategyAddMap textCampaignStrategyAddMap) {
        item.withBiddingStrategy(
                ifNotNull(textCampaignStrategyAddMap, TextCampaignStrategyAddMap::getBean));
        return this;
    }

    public TextCampaignAddItemMap withSettings(TextCampaignSetting... settings) {
        item.withSettings(settings);
        return this;
    }

    public TextCampaignAddItemMap defaultTextCampaign() {
        return this.withBiddingStrategy(new TextCampaignStrategyAddMap().defaultTextCampaignStrategy());
    }

    public TextCampaignAddItemMap textCampaignWithStrategies(
            TextCampaignSearchStrategyTypeEnum searchStrategy,
            TextCampaignNetworkStrategyTypeEnum networkStrategy) {
        return this.withBiddingStrategy(new TextCampaignStrategyAddMap()
                .withSearch(new TextCampaignSearchStrategyAddMap().withBiddingStrategyType(searchStrategy))
                .withNetwork(new TextCampaignNetworkStrategyAddMap().withBiddingStrategyType(networkStrategy)));
    }

    public TextCampaignAddItemMap withRelevantKeywords(RelevantKeywordsSettingAdd relevantKeywordsSettingAdd) {
        item.withRelevantKeywords(relevantKeywordsSettingAdd);
        return this;
    }

    public TextCampaignAddItemMap withCounterIds(ArrayOfInteger arrayOfInteger) {
        item.withCounterIds(arrayOfInteger);
        return this;
    }

    public TextCampaignAddItemMap withCounterIds(Integer... counterIds) {
        return this.withCounterIds(new ArrayOfInteger().withItems(counterIds));
    }

    public TextCampaignAddItemMap withPriorityGoals(PriorityGoalsArrayMap priorityGoalsArrayMap) {
        item.withPriorityGoals(priorityGoalsArrayMap.getBean());
        return this;
    }

    public TextCampaignAddItemMap withPriorityGoals(PriorityGoalsItemMap... priorityGoals) {
        var array = new PriorityGoalsArrayMap().withItems(priorityGoals);
        return this.withPriorityGoals(array);
    }

    public TextCampaignAddItemMap withAttributionModel(AttributionModelEnum attributionModel) {
        item.withAttributionModel(attributionModel);
        return this;
    }
}
