package ru.yandex.autotests.directapi.model.api5.campaigns;

import com.yandex.direct.api.v5.campaigns.TextCampaignNetworkStrategyAdd;
import com.yandex.direct.api.v5.campaigns.TextCampaignNetworkStrategyTypeEnum;

import ru.yandex.direct.currency.Currency;

import static ru.yandex.direct.utils.CommonUtils.ifNotNull;

public class TextCampaignNetworkStrategyAddMap extends TextCampaignStrategyAddBaseMap<TextCampaignNetworkStrategyAddMap> {
    private final TextCampaignNetworkStrategyAdd item;

    public TextCampaignNetworkStrategyAddMap() {
        this(new TextCampaignNetworkStrategyAdd());
    }

    public TextCampaignNetworkStrategyAddMap(TextCampaignNetworkStrategyAdd mobileAppCampaignSearchStrategy) {
        item = mobileAppCampaignSearchStrategy;
    }

    @Override
    protected TextCampaignNetworkStrategyAdd getBean() {
        return item;
    }

    @Override
    protected TextCampaignNetworkStrategyAddMap self() {
        return this;
    }

    public TextCampaignNetworkStrategyAddMap withBiddingStrategyType(
            TextCampaignNetworkStrategyTypeEnum biddingStrategyType) {
        item.withBiddingStrategyType(biddingStrategyType);
        return this;
    }

    public TextCampaignNetworkStrategyAddMap defaultServingOff() {
        return this.withBiddingStrategyType(TextCampaignNetworkStrategyTypeEnum.SERVING_OFF);
    }

    public TextCampaignNetworkStrategyAddMap withNetworkDefault(
            StrategyNetworkDefaultAddMap strategyNetworkDefaultAddMap) {
        item.withNetworkDefault(ifNotNull(strategyNetworkDefaultAddMap, StrategyNetworkDefaultAddMap::getBean));
        return this;
    }

    public TextCampaignNetworkStrategyAddMap defaultMaximumCoverage() {
        return this.withBiddingStrategyType(TextCampaignNetworkStrategyTypeEnum.MAXIMUM_COVERAGE);
    }

    public TextCampaignNetworkStrategyAddMap defaultNetworkDefault() {
        return this.withBiddingStrategyType(TextCampaignNetworkStrategyTypeEnum.NETWORK_DEFAULT)
                .withNetworkDefault(new StrategyNetworkDefaultAddMap());
    }

    public TextCampaignNetworkStrategyAddMap defaultNetworkDefaultWithLimitPercent() {
        return this.withBiddingStrategyType(TextCampaignNetworkStrategyTypeEnum.NETWORK_DEFAULT)
                .withNetworkDefault(new StrategyNetworkDefaultAddMap().defaultStrategyNetworkDefault());
    }

    public TextCampaignNetworkStrategyAddMap defaultWbMaximumClicks(Currency currency) {
        return this.withBiddingStrategyType(TextCampaignNetworkStrategyTypeEnum.WB_MAXIMUM_CLICKS)
                .withWbMaximumClicks(new StrategyMaximumClicksAddMap()
                        .defaultStrategyMaximumClicks(currency));
    }

    public TextCampaignNetworkStrategyAddMap defaultWbMaximumConversionRate(Currency currency, Long goalId) {
        return this.withBiddingStrategyType(TextCampaignNetworkStrategyTypeEnum.WB_MAXIMUM_CONVERSION_RATE)
                .withWbMaximumConversionRate(new StrategyMaximumConversionRateAddMap()
                        .defaultMaximumConversionRateParams(currency)
                        .withGoalId(goalId));
    }

    public TextCampaignNetworkStrategyAddMap defaultAverageCpc(Currency currency) {
        return this.withBiddingStrategyType(TextCampaignNetworkStrategyTypeEnum.AVERAGE_CPC)
                .withAverageCpc(new StrategyAverageCpcAddMap()
                        .defaultStrategyAverageCpc(currency));
    }

    public TextCampaignNetworkStrategyAddMap defaultAverageCpa(Currency currency, Long goalId) {
        return this.withBiddingStrategyType(TextCampaignNetworkStrategyTypeEnum.AVERAGE_CPA)
                .withAverageCpa(new StrategyAverageCpaAddMap()
                        .defaultStrategyAverageCpa(currency)
                        .withGoalId(goalId));
    }

    public TextCampaignNetworkStrategyAddMap defaultAverageRoi(Long goalId) {
        return this.withBiddingStrategyType(TextCampaignNetworkStrategyTypeEnum.AVERAGE_ROI)
                .withAverageRoi(new StrategyAverageRoiAddMap()
                        .defaultStrategyAverageRoi()
                        .withGoalId(goalId));
    }
}
