package ru.yandex.autotests.directapi.model.api5.campaigns;


import com.yandex.direct.api.v5.campaigns.TextCampaignSearchStrategyAdd;
import com.yandex.direct.api.v5.campaigns.TextCampaignSearchStrategyTypeEnum;

import ru.yandex.direct.currency.Currency;

public class TextCampaignSearchStrategyAddMap extends TextCampaignStrategyAddBaseMap<TextCampaignSearchStrategyAddMap> {
    private final TextCampaignSearchStrategyAdd item;

    public TextCampaignSearchStrategyAddMap() {
        this(new TextCampaignSearchStrategyAdd());
    }

    public TextCampaignSearchStrategyAddMap(TextCampaignSearchStrategyAdd mobileAppCampaignSearchStrategy) {
        item = mobileAppCampaignSearchStrategy;
    }

    @Override
    protected TextCampaignSearchStrategyAdd getBean() {
        return item;
    }

    @Override
    protected TextCampaignSearchStrategyAddMap self() {
        return this;
    }

    public TextCampaignSearchStrategyAddMap withBiddingStrategyType(
            TextCampaignSearchStrategyTypeEnum biddingStrategyType) {
        item.withBiddingStrategyType(biddingStrategyType);
        return this;
    }

    public TextCampaignSearchStrategyAddMap defaultServingOff() {
        return this.withBiddingStrategyType(TextCampaignSearchStrategyTypeEnum.SERVING_OFF);
    }

    public TextCampaignSearchStrategyAddMap defaultHighestPosition() {
        return this.withBiddingStrategyType(TextCampaignSearchStrategyTypeEnum.HIGHEST_POSITION);
    }

    public TextCampaignSearchStrategyAddMap defaultWbMaximumClicks(Currency currency) {
        return this.withBiddingStrategyType(TextCampaignSearchStrategyTypeEnum.WB_MAXIMUM_CLICKS)
                .withWbMaximumClicks(new StrategyMaximumClicksAddMap()
                        .defaultStrategyMaximumClicks(currency));
    }

    public TextCampaignSearchStrategyAddMap defaultWbMaximumConversionRate(Currency currency, Long goalId) {
        return this
                .withBiddingStrategyType(TextCampaignSearchStrategyTypeEnum.WB_MAXIMUM_CONVERSION_RATE)
                .withWbMaximumConversionRate(new StrategyMaximumConversionRateAddMap()
                        .defaultMaximumConversionRateParams(currency)
                        .withGoalId(goalId));
    }

    public TextCampaignSearchStrategyAddMap defaultAverageCpc(Currency currency) {
        return this.withBiddingStrategyType(TextCampaignSearchStrategyTypeEnum.AVERAGE_CPC)
                .withAverageCpc(new StrategyAverageCpcAddMap()
                        .defaultStrategyAverageCpc(currency));
    }

    public TextCampaignSearchStrategyAddMap defaultAverageCpa(Currency currency, Long goalId) {
        return this.withBiddingStrategyType(TextCampaignSearchStrategyTypeEnum.AVERAGE_CPA)
                .withAverageCpa(new StrategyAverageCpaAddMap()
                        .defaultStrategyAverageCpa(currency)
                        .withGoalId(goalId));
    }

    public TextCampaignSearchStrategyAddMap defaultPayForConversion(Currency currency, Long goalId) {
        return this.withBiddingStrategyType(TextCampaignSearchStrategyTypeEnum.PAY_FOR_CONVERSION)
                .withPayForConversion(new StrategyPayForConversionAddMap()
                        .defaultStrategyPayForConversion(currency)
                        .withGoalId(goalId));
    }

    public TextCampaignSearchStrategyAddMap defaultAverageRoi(Long goalId) {
        return this.withBiddingStrategyType(TextCampaignSearchStrategyTypeEnum.AVERAGE_ROI)
                .withAverageRoi(new StrategyAverageRoiAddMap()
                        .defaultStrategyAverageRoi()
                        .withGoalId(goalId));
    }

    public TextCampaignSearchStrategyAddMap defaultAverageCrr(Long goalId) {
        return this.withBiddingStrategyType(TextCampaignSearchStrategyTypeEnum.AVERAGE_CRR)
                .withAverageCrr(
                        new StrategyAverageCrrAddMap()
                                .defaultStrategyAverageCrr()
                                .withGoalId(goalId)
                );
    }
}
