package ru.yandex.autotests.directapi.model.api5.campaigns;

import com.yandex.direct.api.v5.campaigns.TextCampaignNetworkStrategyTypeEnum;
import com.yandex.direct.api.v5.campaigns.TextCampaignSearchStrategyTypeEnum;
import com.yandex.direct.api.v5.campaigns.TextCampaignStrategyAdd;

import static ru.yandex.direct.utils.CommonUtils.ifNotNull;

public class TextCampaignStrategyAddMap {
    private final TextCampaignStrategyAdd item;

    public TextCampaignStrategyAddMap() {
        this(new TextCampaignStrategyAdd());
    }

    public TextCampaignStrategyAddMap(TextCampaignStrategyAdd mobileAppCampaignStrategy) {
        item = mobileAppCampaignStrategy;
    }

    public TextCampaignStrategyAdd getBean() {
        return item;
    }

    public TextCampaignStrategyAddMap withSearch(
            TextCampaignSearchStrategyAddMap search) {
        item.withSearch(ifNotNull(search, TextCampaignSearchStrategyAddMap::getBean));
        return this;
    }

    public TextCampaignStrategyAddMap withNetwork(
            TextCampaignNetworkStrategyAddMap network) {
        item.withNetwork(ifNotNull(network, TextCampaignNetworkStrategyAddMap::getBean));
        return this;
    }

    public TextCampaignStrategyAddMap defaultTextCampaignStrategy() {
        return this
                .withSearch(new TextCampaignSearchStrategyAddMap()
                        .withBiddingStrategyType(TextCampaignSearchStrategyTypeEnum.HIGHEST_POSITION))
                .withNetwork(new TextCampaignNetworkStrategyAddMap()
                        .withBiddingStrategyType(TextCampaignNetworkStrategyTypeEnum.MAXIMUM_COVERAGE));
    }
}
