package ru.yandex.autotests.directapi.model.api5.campaigns;

import com.yandex.direct.api.v5.campaigns.TimeTargetingAdd;
import com.yandex.direct.api.v5.campaigns.TimeTargetingBase;

import static ru.yandex.direct.utils.CommonUtils.ifNotNull;

public class TimeTargetingAddMap extends TimeTargetingBaseMap<TimeTargetingAddMap> {

    public static final String HOLIDAYS_SCHEDULE = "holidaysSchedule";
    private final TimeTargetingAdd item;

    public TimeTargetingAddMap() {
        this(new TimeTargetingAdd());
    }

    public TimeTargetingAddMap(TimeTargetingAdd timeTargeting) {
        item = timeTargeting;
    }

    @Override
    protected TimeTargetingAddMap self() {
        return this;
    }

    @Override
    public TimeTargetingBase getBean() {
        return item;
    }

    public TimeTargetingAddMap withHolidaysSchedule(TimeTargetingOnPublicHolidaysMap timeTargetingOnPublicHolidays) {
        item.withHolidaysSchedule(
                ifNotNull(timeTargetingOnPublicHolidays, TimeTargetingOnPublicHolidaysMap::getBean));
        return this;
    }
}
