package ru.yandex.autotests.directapi.model.api5.campaigns;

import com.yandex.direct.api.v5.campaigns.TimeTargetingBase;
import com.yandex.direct.api.v5.general.ArrayOfString;
import com.yandex.direct.api.v5.general.YesNoEnum;

public abstract class TimeTargetingBaseMap<T extends TimeTargetingBaseMap<T>> {

    public static final String SCHEDULE = "schedule";
    public static final String CONSIDER_WORKING_WEEKENDS = "considerWorkingWeekends";
    public static final String[] DEFAULT_SCHEDULE = {
            "1,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50",
            "2,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50",
            "3,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50",
            "4,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50",
            "5,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50",
            "6,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50",
            "7,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50"
    };
    public static final String[] CPM_BANNER_DEFAULT_SCHEDULE = {
            "1,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100",
            "2,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100",
            "3,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100",
            "4,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100",
            "5,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100",
            "6,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100",
            "7,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100,100"
    };

    public TimeTargetingBaseMap() {
        super();
    }

    protected abstract T self();

    public abstract TimeTargetingBase getBean();

    public T withSchedule(ArrayOfString schedule) {
        getBean().withSchedule(schedule);
        return self();
    }

    public T withSchedule(String... items) {
        return this.withSchedule(new ArrayOfString().withItems(items));
    }

    public T withConsiderWorkingWeekends(YesNoEnum considerWorkingWeekends) {
        getBean().withConsiderWorkingWeekends(considerWorkingWeekends);
        return self();
    }
}
