package ru.yandex.autotests.directapi.model.api5.campaigns;

import com.yandex.direct.api.v5.campaigns.ObjectFactory;
import com.yandex.direct.api.v5.campaigns.TimeTargeting;
import com.yandex.direct.api.v5.campaigns.TimeTargetingBase;

import static ru.yandex.direct.utils.CommonUtils.ifNotNull;

public class TimeTargetingMap extends TimeTargetingBaseMap<TimeTargetingMap> {

    public static final String HOLIDAYS_SCHEDULE = "holidaysSchedule";
    private final TimeTargeting item;

    public TimeTargetingMap() {
        this(new TimeTargeting());
    }

    public TimeTargetingMap(TimeTargeting timeTargeting) {
        item = timeTargeting;
    }

    @Override
    protected TimeTargetingMap self() {
        return this;
    }

    @Override
    public TimeTargetingBase getBean() {
        return item;
    }

    public TimeTargetingMap withHolidaysSchedule(TimeTargetingOnPublicHolidaysMap timeTargetingOnPublicHolidaysMap) {
        var timeTargetingOnPublicHolidays =
                ifNotNull(timeTargetingOnPublicHolidaysMap, TimeTargetingOnPublicHolidaysMap::getBean);
        var jaxbElement =
                new ObjectFactory().createTimeTargetingHolidaysSchedule(timeTargetingOnPublicHolidays);
        item.withHolidaysSchedule(jaxbElement);
        return this;
    }
}
