package ru.yandex.autotests.directapi.model.api5.campaigns;

import com.yandex.direct.api.v5.campaigns.TimeTargetingOnPublicHolidays;
import com.yandex.direct.api.v5.general.YesNoEnum;

public class TimeTargetingOnPublicHolidaysMap {

    public static final String SUSPEND_ON_HOLIDAYS = "suspendOnHolidays";
    public static final String START_HOUR = "startHour";
    public static final String END_HOUR = "endHour";
    public static final String BID_PERCENT = "bidPercent";

    public static final int MIN_BID_PERCENT = 10;
    public static final int MAX_BID_PERCENT = 200;
    public static final int DEFAULT_BID_PERCENT = 100;

    private final TimeTargetingOnPublicHolidays item;

    public TimeTargetingOnPublicHolidaysMap() {
        this(new TimeTargetingOnPublicHolidays());
    }

    public TimeTargetingOnPublicHolidaysMap(TimeTargetingOnPublicHolidays timeTargetingOnPublicHolidays) {
        item = timeTargetingOnPublicHolidays;
    }

    public TimeTargetingOnPublicHolidays getBean() {
        return item;
    }

    public TimeTargetingOnPublicHolidaysMap withSuspendOnHolidays(YesNoEnum suspendOnHolidays) {
        item.withSuspendOnHolidays(suspendOnHolidays);
        return this;
    }

    public TimeTargetingOnPublicHolidaysMap withStartHour(Integer startHour) {
        item.withStartHour(startHour);
        return this;
    }

    public TimeTargetingOnPublicHolidaysMap withEndHour(Integer endHour) {
        item.withEndHour(endHour);
        return this;
    }

    public TimeTargetingOnPublicHolidaysMap withBidPercent(Integer bidPercent) {
        item.withBidPercent(bidPercent);
        return this;
    }
}
