package ru.yandex.autotests.directapi.model.api5.dynamictextadtargets;

import java.util.Arrays;

import javax.annotation.ParametersAreNonnullByDefault;

import com.yandex.direct.api.v5.dynamictextadtargets.AddRequest;

import static java.util.stream.Collectors.toList;

@ParametersAreNonnullByDefault
public class AddRequestMap {
    public static final String WEBPAGES = "webpages";
    public static final String ADD_REQUEST = "addRequest";

    private final AddRequest item;

    public AddRequestMap() {
        item = new AddRequest();
    }

    public AddRequest getBean() {
        return item;
    }

    public AddRequestMap withWebpages(WebpageAddItemMap... webpageAddItems) {
        item.withWebpages(Arrays.stream(webpageAddItems).map(WebpageAddItemMap::getBean).collect(toList()));
        return this;
    }
}
