package ru.yandex.autotests.directapi.model.api5.dynamictextadtargets;

import java.util.Arrays;

import com.yandex.direct.api.v5.dynamictextadtargets.WebpageAddItem;
import com.yandex.direct.api.v5.general.PriorityEnum;

import static java.util.stream.Collectors.toList;

/**
 * Created by buhter on 28/08/15.
 */
public class WebpageAddItemMap {

    public static final String NAME = "name";
    public static final String AD_GROUP_ID = "adGroupId";
    public static final String CONDITIONS = "conditions";
    public static final String BID = "bid";
    public static final String CONTEXT_BID = "contextBid";
    public static final String STRATEGY_PRIORITY = "strategyPriority";

    public static final String DEFAULT_NAME = "DefaultWebpageName";

    private final WebpageAddItem item;

    public WebpageAddItemMap() {
        item = new WebpageAddItem();
    }

    public WebpageAddItem getBean() {
        return item;
    }

    public WebpageAddItemMap withName(String name) {
        item.withName(name);
        return this;
    }

    public WebpageAddItemMap withAdGroupId(long adGroupId) {
        item.withAdGroupId(adGroupId);
        return this;
    }

    public WebpageAddItemMap withConditions(WebpageConditionMap... webpageConditions) {
        item.withConditions(Arrays.stream(webpageConditions).map(WebpageConditionMap::getBean).collect(toList()));
        return this;
    }

    public WebpageAddItemMap withBid(Long bid) {
        item.withBid(bid);
        return this;
    }

    public WebpageAddItemMap withContextBid(Long contextBid) {
        item.withContextBid(contextBid);
        return this;
    }

    public WebpageAddItemMap withStrategyPriority(PriorityEnum strategyPriority) {
        item.withStrategyPriority(strategyPriority);
        return this;
    }

    public WebpageAddItemMap defaultWebpage(Long adGroupId) {
        return withAdGroupId(adGroupId)
                .withName(DEFAULT_NAME);
    }
}
