package ru.yandex.autotests.directapi.model.api5.dynamictextadtargets;

import java.util.Arrays;

import com.yandex.direct.api.v5.dynamictextadtargets.StringConditionOperatorEnum;
import com.yandex.direct.api.v5.dynamictextadtargets.WebpageCondition;
import com.yandex.direct.api.v5.dynamictextadtargets.WebpageConditionOperandEnum;

/**
 * Created by buhter on 28/08/15.
 */
public class WebpageConditionMap {

    public static final String OPERAND = "operand";
    public static final String OPERATOR = "operator";
    public static final String ARGUMENTS = "arguments";

    public static final Integer MAX_ARGUMENTS_AMOUNT = 10;
    public static final Integer MAX_LENGTH_OF_OFFERS_LIST_URL_ARGUMENT = 1024;
    public static final Integer MAX_LENGTH_OF_OTHER_OPERAND_ARGUMENT = 100;

    private final WebpageCondition item;

    public WebpageConditionMap() {
        item = new WebpageCondition();
    }

    public WebpageCondition getBean() {
        return item;
    }

    public WebpageConditionMap withOperand(WebpageConditionOperandEnum operand) {
        item.withOperand(operand);
        return this;
    }

    public WebpageConditionMap withOperator(StringConditionOperatorEnum operator) {
        item.withOperator(operator);
        return this;
    }

    public WebpageConditionMap withArguments(String... arguments) {
        item.withArguments(Arrays.asList(arguments));
        return this;
    }

    public WebpageConditionMap defaultWebpage() {
        return this.withArguments("default webpage")
                .withOperator(StringConditionOperatorEnum.CONTAINS_ANY)
                .withOperand(WebpageConditionOperandEnum.PAGE_CONTENT);
    }
}
