package ru.yandex.autotests.directapi.model.api5.general;

import java.util.List;

import javax.annotation.Nullable;

import ru.yandex.autotests.direct.utils.textresource.ITextResource;

import static java.util.Arrays.asList;

public class Notification {
    private final int errorCode;
    @Nullable
    private final ITextResource textResource;
    private final List<Object> params;

    public Notification(int errorCode, @Nullable ITextResource details, Object... params) {
        this.errorCode = errorCode;
        this.textResource = details;
        this.params = asList(params);
    }

    public int getErrorCode() {
        return errorCode;
    }

    @Nullable
    public ITextResource getDetailsResource() {
        return textResource;
    }

    public List<Object> getParams() {
        return params;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        Notification that = (Notification) o;

        if (errorCode != that.errorCode) {
            return false;
        }
        if (!textResource.equals(that.textResource)) {
            return false;
        }
        return params != null ? params.equals(that.params) : that.params == null;
    }

    @Override
    public int hashCode() {
        int result = errorCode;
        result = 31 * result + textResource.hashCode();
        result = 31 * result + (params != null ? params.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "Notification{" +
                "errorCode=" + errorCode +
                ", textResource=" + textResource +
                ", params=" + params +
                '}';
    }
}
