package ru.yandex.autotests.directapi.model.api5.general;

import java.util.ArrayList;
import java.util.List;

import com.yandex.direct.api.v5.general.ExceptionNotification;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

import ru.yandex.autotests.directapi.apiclient.errors.Api5ErrorMessage;
import ru.yandex.direct.common.TranslationService;
import ru.yandex.direct.i18n.Translatable;

import static org.hamcrest.Matchers.equalTo;
import static org.hamcrest.Matchers.hasProperty;
import static ru.yandex.direct.utils.CommonUtils.ifNotNull;

class TranslatableNotification {
    private final int code;
    private final Translatable message;
    private final Translatable details;
    private final boolean matchDetails;
    private final boolean matchMessage;

    TranslatableNotification(int code,
                             Translatable message,
                             Translatable details,
                             boolean matchDetails,
                             boolean matchMessage) {
        this.code = code;
        this.message = message;
        this.details = details;
        this.matchDetails = matchDetails;
        this.matchMessage = matchMessage;
    }

    public static TranslatableNotification fromNotification(Notification notification) {
        int errorCode = notification.getErrorCode();
        return new TranslatableNotification(
                errorCode,
                Api5ErrorMessage.fromNotificationCode(errorCode).getTranslatable(),
                ifNotNull(notification.getDetailsResource(), x -> x.getTranslatable(notification.getParams())),
                true,
                true);
    }

    public static TranslatableNotification fromErrorCode(Integer errorCode) {
        return new TranslatableNotification(
                errorCode,
                Api5ErrorMessage.fromNotificationCode(errorCode).getTranslatable(),
                null,
                false,
                true);
    }

    public TranslatableNotification ignoringDetails() {
        return new TranslatableNotification(code, message, details, false, matchMessage);
    }

    public TranslatableNotification ignoringMessage() {
        return new TranslatableNotification(code, message, details, matchDetails, false);
    }

    Matcher<ExceptionNotification> getMatcher(TranslationService translationService) {
        List<Matcher<? super ExceptionNotification>> matchers = new ArrayList<>();
        matchers.add(hasProperty("code", equalTo(code)));
        if (matchDetails) {
            matchers.add(hasProperty("details", equalTo(translationService.translate(details))));
        }
        if (matchMessage) {
            matchers.add(hasProperty("message", equalTo(translationService.translate(message))));
        }

        return Matchers.allOf(matchers);
    }
}
