package ru.yandex.autotests.directapi.model.api5.keywords;

import com.yandex.direct.api.v5.general.PriorityEnum;
import com.yandex.direct.api.v5.keywords.KeywordAddItem;

import ru.yandex.autotests.direct.utils.PhraseTexts;


/**
 * Created by chicos on 20.11.14.
 */
public class KeywordAddMap {

    public static final String KEYWORD = "keyword";
    public static final String ADGROUP_ID = "adGroupId";
    public static final String USER_PARAM_1 = "userParam1";
    public static final String USER_PARAM_2 = "userParam2";
    public static final String STRATEGY_PRIORITY = "strategyPriority";
    public static final String BID = "bid";
    public static final String CONTEXT_BID = "contextBid";

    public static final String AUTOTARGETING_KEYWORD = "---autotargeting";

    public static final int MAX_USER_PARAM_LENGTH = 255;

    private static PhraseTexts phrases = new PhraseTexts();

    private KeywordAddItem item;

    public KeywordAddMap() {
        item = new KeywordAddItem();
    }

    public KeywordAddMap shortKeyword() {
        item = new KeywordAddItem();
        this.withKeyword(phrases.getNext());
        return this;
    }

    public KeywordAddMap defaultKeyword() {
        item = new KeywordAddItem();
        return this.withKeyword(phrases.getNext())
                .withUserParam1("123456")
                .withUserParam2("superParam");
    }

    public KeywordAddMap shortAutotargeting(Long adGroupId) {
        item = new KeywordAddItem();
        return this.withAdGroupId(adGroupId).withKeyword(AUTOTARGETING_KEYWORD);
    }

    public KeywordAddMap autotargeting(Long adGroupId) {
        return shortAutotargeting(adGroupId)
                .withUserParam1("123456")
                .withUserParam2("superParam");
    }

    public KeywordAddMap withKeyword(String keyword) {
        item.withKeyword(keyword);
        return this;
    }

    public KeywordAddMap withAdGroupId(long adGroupId) {
        item.withAdGroupId(adGroupId);
        return this;
    }

    public KeywordAddMap withUserParam1(String param1) {
        item.withUserParam1(param1);
        return this;
    }

    public KeywordAddMap withUserParam2(String param2) {
        item.withUserParam2(param2);
        return this;
    }

    public KeywordAddMap withStrategyPriority(PriorityEnum strategyPriority) {
        item.withStrategyPriority(strategyPriority);
        return this;
    }

    public KeywordAddMap withBid(Long bid) {
        item.withBid(bid);
        return this;
    }

    public KeywordAddMap withContextBid(Long contextBid) {
        item.withContextBid(contextBid);
        return this;
    }

    public KeywordAddItem getBean() {
        return item;
    }
}
