package ru.yandex.autotests.directapi.model.api5.keywordsresearch;

import javax.annotation.ParametersAreNonnullByDefault;

import com.yandex.direct.api.v5.keywordsresearch.DeduplicateRequestItem;

@ParametersAreNonnullByDefault
public class DeduplicateRequestItemMap {

    public static final String ID = "id";
    public static final String KEYWORD = "keyword";
    public static final String WEIGHT = "weight";

    private final DeduplicateRequestItem item;

    public DeduplicateRequestItemMap() {
        item = new DeduplicateRequestItem();
    }

    public DeduplicateRequestItemMap(DeduplicateRequestItem request) {
        item = request;
    }

    public DeduplicateRequestItem getBean() {
        return item;
    }

    public DeduplicateRequestItemMap withKeyword(String keyword) {
        item.withKeyword(keyword);
        return this;
    }

    public DeduplicateRequestItemMap withId(Long id) {
        item.withId(id);
        return this;
    }

    public DeduplicateRequestItemMap withWeight(Long weight) {
        item.withWeight(weight);
        return this;
    }
}
