package ru.yandex.autotests.directapi.model.api5.keywordsresearch;

import java.util.List;
import java.util.stream.Stream;

import com.yandex.direct.api.v5.keywordsresearch.DeduplicateOperationEnum;
import com.yandex.direct.api.v5.keywordsresearch.DeduplicateRequest;
import one.util.streamex.StreamEx;

import static java.util.stream.Collectors.toList;

public class DeduplicateRequestMap {

    private final DeduplicateRequest item;

    public DeduplicateRequestMap() {
        item = new DeduplicateRequest();
    }

    public DeduplicateRequest getBean() {
        return item;
    }

    public DeduplicateRequestMap withKeywords(List<DeduplicateRequestItemMap> keywords) {
        item.withKeywords(keywords.stream().map(DeduplicateRequestItemMap::getBean).collect(toList()));
        return this;
    }

    public DeduplicateRequestMap withKeywords(DeduplicateRequestItemMap... keywords) {
        item.withKeywords(Stream.of(keywords).map(DeduplicateRequestItemMap::getBean).collect(toList()));
        return this;
    }

    public DeduplicateRequestMap withOperations(DeduplicateOperationEnum... operations) {
        item.withOperation(StreamEx.of(operations).toList());
        return this;
    }

    public DeduplicateRequestMap withOperations(List<DeduplicateOperationEnum> operations) {
        item.withOperation(operations);
        return this;
    }
}
