package ru.yandex.autotests.directapi.model.api5.keywordsresearch;

import java.util.List;
import java.util.stream.Stream;

import com.yandex.direct.api.v5.keywordsresearch.HasSearchVolumeFieldEnum;
import com.yandex.direct.api.v5.keywordsresearch.HasSearchVolumeRequest;

import static java.util.stream.Collectors.toList;

public class HasSearchVolumeRequestMap {
    private HasSearchVolumeRequest item;

    public HasSearchVolumeRequestMap() {
        item = new HasSearchVolumeRequest();
    }

    public HasSearchVolumeRequest getBean() {
        return item;
    }

    public HasSearchVolumeRequestMap withSelectionCriteria(HasSearchVolumeSelectionCriteriaMap selectionCriteria) {
        item.withSelectionCriteria(selectionCriteria.getBean());
        return this;
    }

    public HasSearchVolumeRequestMap withFieldNames(HasSearchVolumeFieldEnum... fieldNames) {
        item.withFieldNames(Stream.of(fieldNames).collect(toList()));
        return this;
    }

    public HasSearchVolumeRequestMap withFieldNames(List<HasSearchVolumeFieldEnum> fieldNames) {
        item.withFieldNames(fieldNames);
        return this;
    }
}
