package ru.yandex.autotests.directapi.model.api5.keywordsresearch;

import java.util.List;
import java.util.stream.Stream;

import com.yandex.direct.api.v5.keywordsresearch.HasSearchVolumeSelectionCriteria;

import static java.util.stream.Collectors.toList;

public class HasSearchVolumeSelectionCriteriaMap {
    public static final String KEYWORDS = "keywords";
    public static final String REGION_IDS = "regionIds";

    private final HasSearchVolumeSelectionCriteria item;

    public HasSearchVolumeSelectionCriteriaMap() {
        item = new HasSearchVolumeSelectionCriteria();
    }

    public HasSearchVolumeSelectionCriteriaMap(HasSearchVolumeSelectionCriteria request) {
        item = request;
    }

    public HasSearchVolumeSelectionCriteria getBean() {
        return item;
    }

    public HasSearchVolumeSelectionCriteriaMap withKeywords(String... keywords) {
        item.withKeywords(Stream.of(keywords).collect(toList()));
        return this;
    }

    public HasSearchVolumeSelectionCriteriaMap withKeywords(List<String> keywords) {
        item.withKeywords(keywords);
        return this;
    }

    public HasSearchVolumeSelectionCriteriaMap withRegionIds(Long... regionIds) {
        item.withRegionIds(Stream.of(regionIds).collect(toList()));
        return this;
    }

    public HasSearchVolumeSelectionCriteriaMap withRegionIds(List<Long> regionIds) {
        item.withRegionIds(regionIds);
        return this;
    }
}
