package ru.yandex.autotests.directapi.model.api5.vcards;

import com.yandex.direct.api.v5.vcards.InstantMessenger;

public class InstantMessengerMap {
    public static final String IM_CLIENT = "messengerClient";
    public static final String IM_LOGIN = "messengerLogin";

    private InstantMessenger item;

    public InstantMessengerMap() {
        this.item = new InstantMessenger();
    }

    public InstantMessenger getBean() {
        return item;
    }

    public InstantMessengerMap defaultInstantMessenger() {
        item = new InstantMessenger()
                .withMessengerClient("skype")
                .withMessengerLogin("at-tester");
        return this;
    }

    public InstantMessengerMap withIMClient(String value) {
        item.setMessengerClient(value);
        return this;
    }

    public InstantMessengerMap withIMLogin(String value) {
        item.setMessengerLogin(value);
        return this;
    }
}
